package ru.systematic.cisstat.portlet.display.context;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.portal.kernel.display.context.util.BaseRequestHelper;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.WebKeys;
import com.liferay.portlet.asset.util.AssetUtil;

import ru.systematic.cisstat.util.VideoNewsUtil;

public class VideoNewsDisplayContext {
	
	public VideoNewsDisplayContext(
			PortletRequest portletRequest, PortletResponse portletResponse,
			PortletPreferences portletPreferences) {

			_request = PortalUtil.getHttpServletRequest(portletRequest);
			_portletRequest = portletRequest;
			_portletResponse = portletResponse;

			_portletPreferences = portletPreferences;
		}
	
	public boolean isShowAddContentButton() {
		if (_showAddContentButton == null) {
			_showAddContentButton = GetterUtil.getBoolean(
				_portletPreferences.getValue("showAddContentButton", null),
				true);
		}

		return _showAddContentButton;
	}
	
	public String[] getMimeTypes() throws Exception {
		
			_mimeTypes = _portletPreferences.getValue("selectedMimeTypes", "").split(",");
		return _mimeTypes;
	}
	
	public long getRootFolder() throws Exception {
		
		_rootFolder = Long.parseLong(_portletPreferences.getValue("rootFolderId", "0"), 10);
			
		return _rootFolder;
	}
	
	public String getDisplayStyle() {
		_displayStyle = _portletPreferences.getValue("displayStyle","");
		return _displayStyle;
	}
	
	public String getStyleID() {
		_styleID = _portletPreferences.getValue("styleID","myGallery");
		return _styleID;
	}
	
	public String getCSS() {
		_css = _portletPreferences.getValue("css","");
		return _css;
	}
	
	public Boolean isOneStaticPhoto() {
		_isOneStaticPhoto =  GetterUtil.getBoolean(_portletPreferences.getValue("isOneStaticPhoto","0"), false);
		return _isOneStaticPhoto;
	}
	
	public String getWidthVideo() {
		_widthVideo =  _portletPreferences.getValue("widthVideo","200");
		return _widthVideo;
	}
	
	public Boolean getPosition() {
		_position =  GetterUtil.getBoolean(_portletPreferences.getValue("position","1"), true);
		return _position;
	}
	
	public int getDelta() {
		_delta = GetterUtil.getInteger(_portletPreferences.getValue("delta","4"),4);
		return _delta;
	}
	
	public long[] getGroupIds() {
		if (_groupIds == null) {
			ThemeDisplay themeDisplay = (ThemeDisplay)_request.getAttribute(
				WebKeys.THEME_DISPLAY);

			_groupIds = VideoNewsUtil.getGroupIds(
				_portletPreferences, themeDisplay.getScopeGroupId(),
				themeDisplay.getLayout());
		}

		return _groupIds;
	}
	
	public Map<Long, Map<String, PortletURL>> getScopeAddPortletURLs(int max)
			throws Exception {

			long[] groupIds = getGroupIds();

			if (groupIds.length == 0) {
				return Collections.emptyMap();
			}

			Map<Long, Map<String, PortletURL>> scopeAddPortletURLs = new HashMap();

			LiferayPortletResponse liferayPortletResponse =
				PortalUtil.getLiferayPortletResponse(_portletResponse);

			PortletURL redirectURL = liferayPortletResponse.createRenderURL();

			redirectURL.setParameter(
				"hideDefaultSuccessMessage", Boolean.TRUE.toString());
			redirectURL.setParameter("mvcPath", "/add_asset_redirect.jsp");

			LiferayPortletRequest liferayPortletRequest =
				PortalUtil.getLiferayPortletRequest(_portletRequest);

			PortletURL currentURLObj = PortletURLUtil.getCurrent(
				liferayPortletRequest, liferayPortletResponse);

			redirectURL.setParameter("redirect", currentURLObj.toString());

			redirectURL.setWindowState(LiferayWindowState.POP_UP);

			String redirect = redirectURL.toString();

			for (long groupId : groupIds) {
				Map<String, PortletURL> addPortletURLs =
					AssetUtil.getAddPortletURLs(
						liferayPortletRequest, liferayPortletResponse, groupId,
						getClassNameIds(), getClassTypeIds(),
						getAllAssetCategoryIds(), getAllAssetTagNames(), redirect);

				if (MapUtil.isNotEmpty(addPortletURLs)) {
					scopeAddPortletURLs.put(groupId, addPortletURLs);
				}

				if (scopeAddPortletURLs.size() > max) {
					break;
				}
			}

			return scopeAddPortletURLs;
	}
	
	public String[] getAllAssetTagNames() throws Exception {
		if (_allAssetTagNames != null) {
			return _allAssetTagNames;
		}

		_allAssetTagNames = new String[0];

		String assetTagName = ParamUtil.getString(_request, "tag");

		String selectionStyle = getSelectionStyle();

		if (selectionStyle.equals("dynamic")) {
			_allAssetTagNames = VideoNewsUtil.getAssetTagNames(
				_portletPreferences);
		}

		if (Validator.isNotNull(assetTagName) &&
			!ArrayUtil.contains(_allAssetTagNames, assetTagName)) {

			_allAssetTagNames = ArrayUtil.append(
				_allAssetTagNames, assetTagName);
		}

		if (isMergeURLTags()) {
			_allAssetTagNames = ArrayUtil.append(
				_allAssetTagNames, getCompilerTagNames());
		}

		_allAssetTagNames = ArrayUtil.distinct(
			_allAssetTagNames, new StringComparator());

		return _allAssetTagNames;
	}
	
	public String[] getCompilerTagNames() {
		if (_compilerTagNames != null) {
			return _compilerTagNames;
		}

		_compilerTagNames = new String[0];

		if (isMergeURLTags()) {
			_compilerTagNames = ParamUtil.getParameterValues(_request, "tags");
		}

		return _compilerTagNames;
	}
	
	public boolean isMergeURLTags() {
		if (_mergeURLTags == null) {
			_mergeURLTags = GetterUtil.getBoolean(
				_portletPreferences.getValue("mergeUrlTags", null), true);
		}

		return _mergeURLTags;
	}
	
	public String getSelectionStyle() {
		if (_selectionStyle == null) {
			_selectionStyle = GetterUtil.getString(
				_portletPreferences.getValue("selectionStyle", null),
				"dynamic");
		}

		return _selectionStyle;
	}
	
	public long[] getAllAssetCategoryIds() throws Exception {
		if (_allAssetCategoryIds != null) {
			return _allAssetCategoryIds;
		}

		_allAssetCategoryIds = new long[0];

		long assetCategoryId = ParamUtil.getLong(_request, "categoryId");

		String selectionStyle = getSelectionStyle();

		if (selectionStyle.equals("dynamic")) {
			_allAssetCategoryIds = VideoNewsUtil.getAssetCategoryIds(
				_portletPreferences);
		}

		if ((assetCategoryId > 0) &&
			!ArrayUtil.contains(_allAssetCategoryIds, assetCategoryId)) {

			_allAssetCategoryIds = ArrayUtil.append(
				_allAssetCategoryIds, assetCategoryId);
		}

		return _allAssetCategoryIds;
	}
	
	public long[] getClassNameIds() {
		if (_classNameIds == null) {
			_classNameIds = VideoNewsUtil.getClassNameIds(
				_portletPreferences, getAvailableClassNameIds());
		}

		return _classNameIds;
	}
	
	public long[] getAvailableClassNameIds() {
		if (_availableClassNameIds == null) {
			ThemeDisplay themeDisplay = (ThemeDisplay)_request.getAttribute(
				WebKeys.THEME_DISPLAY);

			_availableClassNameIds =
				AssetRendererFactoryRegistryUtil.getClassNameIds(
					themeDisplay.getCompanyId(), true);
		}

		return _availableClassNameIds;
	}
	
	public long[] getClassTypeIds() {
		if (_classTypeIds == null) {
			_classTypeIds = GetterUtil.getLongValues(
				_portletPreferences.getValues("classTypeIds", null));
		}

		return _classTypeIds;
	}
	
	public String getPortletResource() {
		if (_portletResource == null) {
			_portletResource = ParamUtil.getString(_request, "portletResource");
		}

		return _portletResource;
	}
	
	
	
	
	private long[] _allAssetCategoryIds;
	private long[] _availableClassNameIds;
	private long[] _classNameIds;
	private long[] _classTypeIds;
	private final PortletPreferences _portletPreferences;
	private final PortletRequest _portletRequest;
	private final PortletResponse _portletResponse;
	private final HttpServletRequest _request;
	private Boolean _showAddContentButton;
	private long[] _groupIds;
	private String _portletResource;
	private String[] _allAssetTagNames;
	private String[] _compilerTagNames;
	private Boolean _mergeURLTags;
	private String _selectionStyle;
	
	private String _css;
	private String _styleID;
	private String _widthVideo;
	private Boolean _isOneStaticPhoto;
	
	private String[] _mimeTypes;
	private long _rootFolder;
	private int _delta;
	private String _displayStyle;
	private boolean _position;

}
