package ru.systematic.cisstat.portlet.action;

import java.util.Objects;

import javax.servlet.http.HttpServletRequest;

import org.osgi.service.component.annotations.Component;

import com.liferay.portal.kernel.portlet.ConfigurationAction;
import com.liferay.portal.kernel.portlet.DefaultConfigurationAction;
import com.liferay.portal.kernel.util.Constants;
import com.liferay.portal.kernel.util.ParamUtil;

import ru.systematic.cisstat.constants.VideoNewsPortletKeys;

@Component(
		immediate = true,
		property = {
			"javax.portlet.name=" + VideoNewsPortletKeys.VideoNews
		},
		service = ConfigurationAction.class
	)
public class VideoNewsConfigurationAction extends DefaultConfigurationAction {
	
	@Override
	public String getJspPath(HttpServletRequest request) {
		String cmd = ParamUtil.getString(request, Constants.CMD);

		return "/configuration.jsp";
	}

}
