
<%@ include file="init.jsp" %>


<%
	Set<String> allMediaGalleryMimeTypes = DLUtil.getAllMediaGalleryMimeTypes();
	

	List<KeyValuePair> leftList = new ArrayList<KeyValuePair>();
	List<KeyValuePair> rightList = new ArrayList<KeyValuePair>();
	
	for (String t : currentMimeTypes){
		leftList.add(new KeyValuePair(t,t));
	}
	
	for (String mimeType : allMediaGalleryMimeTypes) {
		KeyValuePair tempKeyValuePair = new KeyValuePair(mimeType,mimeType);
		if (!leftList.contains(tempKeyValuePair)) {
			rightList.add(tempKeyValuePair);
		}
	}
	
	KeyValuePair tempKeyValuePDF = new KeyValuePair("application/pdf","application/pdf");
	if (!leftList.contains(tempKeyValuePDF)) {
		rightList.add(tempKeyValuePDF);
	}
	
	long rootFolderId = assetPublisherDisplayContext.getRootFolder();
	String rootFolderName = StringPool.BLANK;
	if (rootFolderId != DLFolderConstants.DEFAULT_PARENT_FOLDER_ID) {
		try {
			Folder rootFolder = DLAppLocalServiceUtil.getFolder(rootFolderId);

			rootFolderName = rootFolder.getName();

			if (rootFolder.getGroupId() != scopeGroupId) {
				rootFolderId = DLFolderConstants.DEFAULT_PARENT_FOLDER_ID;
				rootFolderName = StringPool.BLANK;
			}
		}
		catch (NoSuchFolderException nsfe) {
			rootFolderId = DLFolderConstants.DEFAULT_PARENT_FOLDER_ID;
		}
	}
	
	
%>


<liferay-portlet:actionURL portletConfiguration="<%= true %>" var="configurationActionURL" />

<liferay-portlet:renderURL portletConfiguration="<%= true %>" varImpl="configurationRenderURL" />

<aui:form action="<%= configurationActionURL %>" method="post" name="fm" onSubmit="event.preventDefault();">
	<aui:input name="<%= Constants.CMD %>" type="hidden" value="<%= Constants.UPDATE %>" />
	<aui:input name="redirect" type="hidden" value="<%= configurationRenderURL.toString() %>" />
	<aui:input name="groupId" type="hidden" />
	<aui:input name="preferences--rootFolderId--" type="hidden" value="<%= rootFolderId %>" />
	
	
	<div class="portlet-configuration-body-content">
		<aui:fieldset-group markupView="lexicon">
		
			<aui:fieldset cssClass="general-display-settings">
				<aui:input helpMessage="show-add-content-button-help" name="preferences--showAddContentButton--" type="toggle-switch" value="<%= assetPublisherDisplayContext.isShowAddContentButton() %>" />
				
				<aui:input helpMessage="horizontally-vertically" name="preferences--position--" type="toggle-switch" value="<%= assetPublisherDisplayContext.getPosition() %>" />
				
				<aui:input name="preferences--allLevelsPDF--" type="toggle-switch" value="<%= assetPublisherDisplayContext.isallLevelsPDF() %>"/>
				
				<aui:input name="preferences--selectedMimeTypes--" type="hidden" />
				
				<aui:input name="preferences--styleID--" type="text" value="<%= assetPublisherDisplayContext.getStyleID() %>"/>
				
				<aui:input name="preferences--css--" type="textarea" value="<%= assetPublisherDisplayContext.getCSS() %>"/>
				
				<aui:input name="preferences--isOneStaticPhoto--" type="toggle-switch" value="<%= assetPublisherDisplayContext.isOneStaticPhoto() %>"/>
				
				<aui:input name="preferences--widthVideo--" type="text" value="<%= assetPublisherDisplayContext.getWidthVideo() %>"/>
				
				<aui:field-wrapper label="show-media-type">
					<liferay-ui:input-move-boxes
						leftBoxName="currentMimeTypes"
						leftList="<%= leftList %>"
						leftReorder="<%= Boolean.TRUE.toString() %>"
						leftTitle="current"
						rightBoxName="availableMimeTypes"
						rightList="<%= rightList %>"
						rightTitle="available"
					/>
				</aui:field-wrapper>
				
				<aui:field-wrapper label="folder">
					<div class="form-group">
						<aui:input label="root-folder" name="rootFolderName" type="resource" value="<%= rootFolderName %>" />
	
						<aui:button name="openFolderSelectorButton" value="select" />
	
						<%
						String taglibRemoveFolder = "Liferay.Util.removeEntitySelection('rootFolderId', 'rootFolderName', this, '" + renderResponse.getNamespace() + "');";
						%>
	
						<aui:button disabled="<%= rootFolderId <= 0 %>" name="removeFolderButton" onClick="<%= taglibRemoveFolder %>" value="remove" />
					</div>
				</aui:field-wrapper>
				
				
				<div class="display-template">
					<liferay-ddm:template-selector
						className="<%= FileEntry.class.getName() %>"
						displayStyle="<%= displayStyle %>"
						displayStyleGroupId="<%= displayStyleGroupId %>"
						refreshURL="<%= configurationRenderURL.toString() %>"
						showEmptyOption="<%= true %>"
					/>
				</div>
				
			<aui:input helpMessage="number-of-items-to-display-help" label="number-of-items-to-display" name="preferences--delta--" type="text" value="<%= assetPublisherDisplayContext.getDelta() %>">
				<aui:validator name="digits" />
			</aui:input>
				
			</aui:fieldset>
			
		</aui:fieldset-group>
	</div>

	<aui:button-row>
		<aui:button cssClass="btn-lg" onClick='<%= renderResponse.getNamespace() + "saveSelectBoxes();" %>' type="submit" />
	</aui:button-row>
	
</aui:form>

<aui:script>
	AUI.$('#<portlet:namespace />openFolderSelectorButton').on(
		'click',
		function(event) {
			Liferay.Util.selectEntity(
				{
					dialog: {
						constrain: true,
						destroyOnHide: true,
						modal: true,
						width: 680
					},
					id: '_<%= HtmlUtil.escapeJS(PortletKeys.DOCUMENT_LIBRARY) %>_selectFolder',
					title: '<liferay-ui:message arguments="folder" key="select-x" />',

					<liferay-portlet:renderURL var="selectFolderURL" windowState="<%= LiferayWindowState.POP_UP.toString() %>" portletName="<%= PortletKeys.DOCUMENT_LIBRARY %>">
						<portlet:param name="mvcRenderCommandName" value='<%= "/document_library/select_folder" %>' />
						<portlet:param name="folderId" value="<%= String.valueOf(rootFolderId) %>" />
						<portlet:param name="ignoreRootFolder" value="<%= Boolean.TRUE.toString() %>" />
					</liferay-portlet:renderURL>

					uri: '<%= HtmlUtil.escapeJS(selectFolderURL.toString()) %>'
				},
				function(event) {
					var folderData = {
						idString: 'rootFolderId',
						idValue: event.folderid,
						nameString: 'rootFolderName',
						nameValue: event.foldername
					};

					Liferay.Util.selectFolder(folderData, '<portlet:namespace />');
				}
			);
		}
	);

	function <portlet:namespace />saveSelectBoxes() {
		var Util = Liferay.Util;
		
		if (document.<portlet:namespace />fm.<portlet:namespace />selectedMimeTypes) {
			document.<portlet:namespace />fm.<portlet:namespace />selectedMimeTypes.value = Liferay.Util.listSelect(document.<portlet:namespace />fm.<portlet:namespace />currentMimeTypes);
		}
	
		var form = AUI.$(document.<portlet:namespace />fm);
		submitForm(form);
	}
		
</aui:script>
