<nav class="${nav_css_class} navbar navbar-default" id="navigation" role="navigation">
	<h1 class="hide-accessible"><@liferay.language key="navigation" /></h1>
	<div class="xs-menu-navbar visible-xs">
		<#assign current_page_title = page.getName(locale) />
		<#assign first_item = true />
		<#list nav_items as nav_item>
			<#if nav_item.isSelected()>
				<#assign current_page_title = nav_item.getName() />
				<#if first_item>
					<#assign show_breadcrumps = false />
				</#if>
			</#if>
			<#assign first_item = false />
		</#list>
		<div class="navbar-header">
	  	<div class="pull-left">
	    	<button type="button" class="navbar-toggle pull-left collapsed" data-toggle="collapse" data-target="#main-nav-navbar-collapse" aria-expanded="false">
	      <span class="oecd-menu_open"></span>
	      <span class="oecd-menu_close">×</span>
	      <span class="sr-only">Menu</span></button>
	      <div class="page-name pull-left">${current_page_title}</div>
	    </div>
			<div class="pull-right">
				<div class="pull-left lang-nav">
					<#assign preferences = freeMarkerPortletPreferences.getPreferences("portletSetupPortletDecoratorId", "barebone") />
				  <@liferay.languages default_preferences="${preferences}" />
				</div>
				<button type="submit" class="btn btn-default btn-search pull-left collapsed"
					data-toggle="collapse" data-target="#xs-search-collapse" aria-expanded="false">
					<span class="search_open">
						<i class="glyphicon glyphicon-search"></i>
					</span>
	        <span class="search_close">×</span>
					<span class="sr-only">Search</span>
	      </button>
			</div>
		</div>
		<div class="navbar-collapse search-collapse collapse" id="xs-search-collapse"
			aria-expanded="false" style="height: 1px;">
			<@liferay.search />
		</div>
		<div class="navbar-collapse collapse" id="main-nav-navbar-collapse" aria-expanded="false" style="height: 1px;">
			<ul class="nav navbar-nav xs-navbar-nav">
			<#list nav_items as nav_item>
				<#assign
					nav_item_css_class = ""
					nav_item_attr_dropdown = ""
				/>
				<#if nav_item.isSelected()>
					<#assign
						nav_item_css_class = "current-page"
					/>
				</#if>
				<#if nav_item.hasChildren()>
					<#assign
						nav_item_css_class = nav_item_css_class + " dropdown"
						nav_item_role = "button"
						nav_item_attr_dropdown = "class='dropdown-toggle' data-toggle='dropdown'"
					/>
				</#if>

				<li class="${nav_item_css_class}">
					<a href="${nav_item.getURL()}" ${nav_item_attr_dropdown}> ${nav_item.getName()}
					<#if nav_item.hasChildren()>
						<i class="glyphicon glyphicon-menu-down pull-right"></i>
					</#if>
					</a>
					<#if nav_item.hasChildren()>
						<#assign
							child_item_css_class = ""
						/>
						<#if nav_item.isSelected()>
							<#assign
								child_item_css_class = "child_current_page"
							/>
						</#if>
					<ul class="dropdown-menu">
						<#list nav_item.getChildren() as nav_child>
							<li class="${child_item_css_class}">
								<a href="${nav_child.getURL()}"> ${nav_child.getName()}</a>
							</li>
						</#list>
					</ul>
					</#if>
				</li>
			</#list>
			</ul>
		</div>
  </div>

	<div class="container">
		<div id="main-nav-navbar-collapse" class="collapse navbar-collapse custom-dropdown-wrapper">
			<ul aria-label="<@liferay.language key="site-pages" />" role="menubar" class="nav navbar-nav oecd-main-nav">
			<#list nav_items as nav_item>
				<#assign
					nav_item_attr_has_popup = ""
					nav_item_attr_selected = ""
					nav_item_css_class = ""
					nav_item_layout = nav_item.getLayout()
					nav_item_role = "menuitem"
					nav_item_attr_dropdown = ""
				/>

				<#if nav_item.isSelected()>
					<#assign
						nav_item_attr_has_popup = "aria-haspopup='true'"
						nav_item_attr_selected = "aria-selected='true'"
						nav_item_css_class = "selected"
					/>
				</#if>

				<#if nav_item.hasChildren()>
					<#assign
						nav_item_css_class = nav_item_css_class + " dropdown"
						nav_item_role = "button"
						nav_item_attr_dropdown = "class='dropdown-toggle' data-toggle='dropdown'"
					/>
				</#if>

				<li ${nav_item_attr_selected} class="${nav_item_css_class}" id="layout_${nav_item.getLayoutId()}" role="presentation">
					<a aria-labelledby="layout_${nav_item.getLayoutId()}" ${nav_item_attr_has_popup} ${nav_item_attr_dropdown} href="${nav_item.getURL()}" ${nav_item.getTarget()} role="${nav_item_role}"><span><@liferay_theme["layout-icon"] layout=nav_item_layout /> ${nav_item.getName()}</span>
						<#if nav_item.hasChildren()>
							<i class="glyphicon glyphicon-menu-down icon-before"></i>
						</#if>
					</a>

				<#if nav_item.hasChildren()>
					<ul class="dropdown-menu child-menu list-wrapper list-topic-wrapper" role="menu">
						<div class="col-4">
						<#list nav_item.getChildren() as nav_child>
							<#assign
								nav_child_attr_selected = ""
								nav_child_css_class = ""
							/>

							<#if nav_item.isSelected()>
								<#assign
									nav_child_attr_selected = "aria-selected='true'"
									nav_child_css_class = "selected"
								/>
							</#if>

							<li ${nav_child_attr_selected} class="${nav_child_css_class}" id="layout_${nav_child.getLayoutId()}" role="presentation">
								<a aria-labelledby="layout_${nav_child.getLayoutId()}" href="${nav_child.getURL()}" ${nav_child.getTarget()} role="menuitem">${nav_child.getName()}</a>
							</li>
						</#list>
						</div>
					</ul>
				</#if>
				</li>
			</#list>
			</ul>
			<div class="nav navbar-nav navbar-right lang-nav">
				<#assign preferences = freeMarkerPortletPreferences.getPreferences("portletSetupPortletDecoratorId", "barebone") />
			  <@liferay.languages default_preferences="${preferences}" />
      </div>
		</div>
	</div>
</nav>
