<nav class="${nav_css_class} navbar navbar-default" id="navigation" role="navigation">
	<div class="container">
		<div id="main-nav-navbar-collapse" class="collapse navbar-collapse custom-dropdown-wrapper">
			<ul aria-label="<@liferay.language key="site-pages" />" role="menubar" class="nav navbar-nav oecd-main-nav">
			<#list nav_items as nav_item>
				<#assign
					nav_item_attr_has_popup = ""
					nav_item_attr_selected = ""
					nav_item_css_class = ""
					nav_item_layout = nav_item.getLayout()
					nav_item_role = "menuitem"
					nav_item_attr_dropdown = ""
				/>

				<#if nav_item.isSelected()>
					<#assign
						nav_item_attr_has_popup = "aria-haspopup='true'"
						nav_item_attr_selected = "aria-selected='true'"
						nav_item_css_class = "selected"
					/>
				</#if>

				<#if nav_item.hasChildren()>
					<#assign
						nav_item_css_class = nav_item_css_class + " dropdown"
						nav_item_role = "button"
						nav_item_attr_dropdown = "class='dropdown-toggle' data-toggle='dropdown'"
					/>
				</#if>

				<li ${nav_item_attr_selected} class="${nav_item_css_class}" id="layout_${nav_item.getLayoutId()}" role="presentation">
					<a aria-labelledby="layout_${nav_item.getLayoutId()}" ${nav_item_attr_has_popup} ${nav_item_attr_dropdown} href="${nav_item.getURL()}" ${nav_item.getTarget()} role="${nav_item_role}"><span><@liferay_theme["layout-icon"] layout=nav_item_layout /> ${nav_item.getName()}</span>
						<#if nav_item.hasChildren()>
							<i class="glyphicon glyphicon-menu-down icon-before"></i>
						</#if>
					</a>

				<#if nav_item.hasChildren()>
					<ul class="dropdown-menu child-menu list-wrapper list-topic-wrapper" role="menu">
						<div class="col-4">
						<#list nav_item.getChildren() as nav_child>
							<#assign
								nav_child_attr_selected = ""
								nav_child_css_class = ""
							/>

							<#if nav_item.isSelected()>
								<#assign
									nav_child_attr_selected = "aria-selected='true'"
									nav_child_css_class = "selected"
								/>
							</#if>
							
							<#if nav_child.getName()=="SignIn">
								<#if is_signed_in>
									<li class="${nav_child_css_class}">
										<a href="${sign_out_url}" id="sign-out" rel="nofollow" class="oecd-header__current-page">${sign_out_text}</a>
									</li>
								<#else>
								<li class="${nav_child_css_class}">
									<a href="${sign_in_url}" id="sign-in" rel="nofollow" class="oecd-header__current-page">${sign_in_text}</a>
								</li>
								</#if>
							<#else>

							<li ${nav_child_attr_selected} class="${nav_child_css_class}" id="layout_${nav_child.getLayoutId()}" role="presentation">
								<a aria-labelledby="layout_${nav_child.getLayoutId()}" href="${nav_child.getURL()}" ${nav_child.getTarget()} role="menuitem">${nav_child.getName()}</a>
								
									<#if nav_child.hasChildren()>
										<ul class="grandchild-menu" role="menu">
											<div>
												<#list nav_child.getChildren() as nav_grandchild>
													<#assign
														nav_grandchild_attr_selected = ""
														nav_grandchild_css_class = ""
													/>
													<#if nav_grandchild.isSelected()>
														<#assign
															nav_grandchild_attr_selected = "aria-selected='true'"
															nav_grandchild_css_class = "selected"
														/>
													</#if>
													<li ${nav_grandchild_attr_selected} class="${nav_grandchild_css_class}" id="layout_${nav_grandchild.getLayoutId()}" role="presentation">
														<a aria-labelledby="layout_${nav_grandchild.getLayoutId()}" href="${nav_grandchild.getURL()}" ${nav_grandchild.getTarget()} role="menuitem">${nav_grandchild.getName()}</a>
													</li>
												</#list>
											</div>
										</ul>
									</#if>
							</li>
						 </#if>
						</#list>
						</div>
					</ul>
				</#if>
				</li>
			</#list>
			</ul>
		</div>
	</div>
</nav>
