<!DOCTYPE html>

<#include init />

<html class="${root_css_class}" dir="<@liferay.language key="lang.dir" />" lang="${w3c_language_id}">

<head>
	<title>${the_title} - ${company_name}</title>

	<meta content="initial-scale=1.0, width=device-width" name="viewport" />

	<@liferay_util["include"] page=top_head_include />
</head>

<body class="${css_class} oecd-body">

<@liferay_ui["quick-access"] contentId="#main-content" />

<@liferay_util["include"] page=body_top_include />

<@liferay.control_menu />

<div id="wrapper">
	<header class="oecd-header oecd-header--bg-white oecd-header--primary-hidden">
		<nav class="container">
			<div class="row">
				<div class="col-sm-1 oecd-header__item oecd-header__logo-and-toggle">
					<div class="oecd-header__logo ${oecd_header__logo_css}">
						<div class="sr-only">
							${cis_stat_full_name_text}
						</div>
					</div>
					<button class="oecd-header__primary-toggle" title="${toggle_menu_text}">
						<span class="oecd-header__menu-open"></span>
						<span class="oecd-header__menu-close">×</span>
						<span class="sr-only">${menu_text}</span>
					</button>
				</div>
				<ul class="oecd-header__primary" tabindex="0">
					<#include "${full_templates_path}/topmenu.ftl" />
				</ul>
			</div>
			
		</nav>
	</header>
	<div id="banner" role="banner">
		<div id="heading">
			<div class="oecd-menu oecd-menu--bg-dark-blue">
				<div class="oecd-menu-top-wrapper">
					<div class="container">
						<div class="oecd-menu-top hidden-xs">
							<a href="${site_default_url}" title="<@liferay.language_format arguments="${site_name}" key="go-to-x" />">
								<div class="pull-left oecd-menu-logo ${oecd_menu_logo_css}"></div>
							</a>
							<div class="pull-right oecd-search-wrapper">
					 			<div class="oecd-search-before pull-left"></div>
					 			<div class="oecd-search-after pull-left"></div>
					 			<div class="oecd-search pull-left">
									<div class="navbar-form navbar-right" role="search">
										<@liferay.search />
									</div>
					 			</div>
							</div>
						</div>
					</div>
				</div>

			<#assign show_breadcrumps = true />
			<#if has_navigation && is_setup_complete>
				<div class="oecd-menu-bottom-wrapper">
					<#include "${full_templates_path}/navigation.ftl" />
				</div>
			</#if>

			<#if show_breadcrumps >
				<nav id="breadcrumbs"  class="container">
					<@liferay.breadcrumbs />
				</nav>
			</#if>

			</div>
		</div>
	</div>

	<section id="content" class="container">
		<#if show_breadcrumps >
			<div id="contentheading">
				<h1>${page.getName(locale)}</h1>
			</div>
		</#if>
		<div id="contentbody">
		<#if selectable>
			<@liferay_util["include"] page=content_include />
		<#else>
			${portletDisplay.recycle()}

			${portletDisplay.setTitle(the_title)}

			<@liferay_theme["wrap-portlet"] page="portlet.ftl">
				<@liferay_util["include"] page=content_include />
			</@>
		</#if>
		</div>
	</section>

	<footer id="footer" role="contentinfo" class="oecd-footer">
		<div class="oecd-institutional-footer">
			<div class="container">
	      <div class="row">
					<div class="col-xs-3 col-sm-6 oecd-institutional-footer__name">CISStat.com</div>
					<#if is_signed_in>
					<div class="col-xs-3 col-sm-2"><a
						href="${sign_out_url}" id="sign-out" rel="nofollow">${sign_out_text}</a></div>
					<#else>
					<div class="col-xs-3 col-sm-2"><a data-redirect="${is_login_redirect_required?string}"
						href="${sign_in_url}" id="sign-in" rel="nofollow">${sign_in_text}</a></div>
					</#if>
					<div class="col-xs-3 col-sm-2"><a href="${site_default_url}/sitemap/">${site_map_text}</a></div>
					<div class="col-xs-3 col-sm-2"><a href="${site_default_url}/contact/">${contact_us_text}</a></div>
				</div>
			</div>
		</div>
		<div class="oecd-shared-footer oecd-shared-footer--light">
    	<div class="container">
      	<div class="row">
        	<div class="col-xs-7 col-sm-5 oecd-shared-footer__logo-and-copyright">
          	<div class="oecd-shared-footer__logo ${oecd_shared_footer__logo_css}"></div>
            <div class="oecd-shared-footer__copyright">
            	<span class="oecd-shared-footer__copyright-first">
	              © 2017 ${cis_stat_name_text}
              </span>
              <span class="oecd-shared-footer__copyright-second">
              	${welcome_to_statistics_text}
              </span>
            </div>
          </div>
          <div class="col-xs-5 col-sm-3 oecd-shared-footer__terms">
          	<ul class="oecd-shared-footer__links">
            	<li class="oecd-shared-footer__link-item">
								<a href="${site_default_url}/termsandconditions/">
									${terms_and_conditions_text}
								</a>
							</li>
							<li class="oecd-shared-footer__link-item">
								<a href="${site_default_url}/privacy/">
									${privacy_policy_text}
								</a>
							</li>
     				</ul>
          </div>
          <div class="col-xs-12 col-sm-4 oecd-shared-footer__social-media">
          	<p><a href="${site_default_url}/social-media/">${social_media_text}:</a></p>
            <ul class="oecd-shared-footer__icons">
            	<li class="oecd-shared-footer__icon">
              	<a href="http://www.facebook.com/theOECD" class="oecd-shared-footer__icon-link oecd-shared-footer__facebook">Facebook</a>
              </li>
              <li class="oecd-shared-footer__icon">
              	<a href="http://twitter.com/oecd" class="oecd-shared-footer__icon-link oecd-shared-footer__twitter">Twitter</a>
              </li>
              <li class="oecd-shared-footer__icon">
              	<a href="http://www.youtube.com/oecd" class="oecd-shared-footer__icon-link oecd-shared-footer__youtube">YouTube</a>
              </li>
              <li class="oecd-shared-footer__icon">
              	<a href="https://www.linkedin.com/company/organisation-eco-cooperation-development-organisation-cooperation-developpement-eco" class="oecd-shared-footer__icon-link oecd-shared-footer__linkedin">LinkedIn</a>
              </li>
              <li class="oecd-shared-footer__icon">
              	<a href="https://www.flickr.com/photos/oecd" class="oecd-shared-footer__icon-link oecd-shared-footer__flickr">Flickr</a>
              </li>
              <li class="oecd-shared-footer__icon">
              	<a href="${site_default_url}/rssfeeds/" class="oecd-shared-footer__icon-link oecd-shared-footer__rss">RSS</a>
              </li>
              <li class="oecd-shared-footer__icon">
              	<a href="${site_default_url}/contact/" class="oecd-shared-footer__icon-link oecd-shared-footer__oecddirect">CISStat Direct</a>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </div>
	</footer>
</div>

<@liferay_util["include"] page=body_bottom_include />

<@liferay_util["include"] page=bottom_include />

<script src="${javascript_folder}/oecd-headers-footers.js" type="text/javascript"></script>

<!-- inject:js -->
<!-- endinject -->

</body>

</html>
