<!DOCTYPE html>

<#include init />

<html class="${root_css_class}" dir="<@liferay.language key="lang.dir" />" lang="${w3c_language_id}">

<head>
	<title>${the_title} - ${company_name}</title>

	<meta content="initial-scale=1.0, width=device-width" name="viewport" /> 

	<@liferay_util["include"] page=top_head_include />
	
	<!--[if gt IE 8]>
		<style type="text/css">
			#clients .lfr-asset-item{
				margin-left: 15px;
				margin-right: 15px;
			}
		</style>
	<!--<![endif]-->
</head>

<body class="${css_class} oecd-body">

<@liferay_ui["quick-access"] contentId="#main-content" />

<@liferay_util["include"] page=body_top_include />

<@liferay.control_menu />

<div id="wrapper">
	<header class="oecd-header oecd-header--bg-white oecd-header--primary-hidden">
		<nav class="container">
			<div class="row">
				<div class="oecd-header__item oecd-header__logo-and-toggle">
					<a class="${logo_css_class}" href="${site_default_url}" title="<@liferay.language_format arguments="${site_name}" key="go-to-x" />">
						<div class="oecd-header__logo" style="background: url('${site_logo}') left center no-repeat;"></div>
					</a>
					
					<div class="pull-right logo-header-right">
						<div class="sitemap"><a href="${site_default_url}/sitemap/">${site_map_text}</a></div>
						
						<div class="navbar-nav">
							<#assign preferences = freeMarkerPortletPreferences.getPreferences("portletSetupPortletDecoratorId", "barebone") />
							<@liferay.languages default_preferences="${preferences}" />
						</div>
						
						<div class="oecd-search">
							<div class="navbar-form navbar-right" role="search">
									<@liferay.search default_preferences = "${preferences}"/>
							</div>
			 			</div>
			 		</div>

				</div>
			</div>
			
		</nav>
	</header>
	<div id="banner" role="banner">
		<div id="heading">
			<div class="oecd-menu oecd-menu--bg-dark-blue">
				<div class="oecd-menu-top-wrapper">
					<div class="container">
						<div class="oecd-menu-top hidden-xs">
							<ul class="oecd-header__primary" tabindex="0">
								<#include "${full_templates_path}/topmenu.ftl" />
							</ul>
						</div>
					</div>
				</div>

			<#assign show_breadcrumps = true />
			<#if has_navigation && is_setup_complete>
				<div class="oecd-menu-bottom-wrapper">
					<#include "${full_templates_path}/navigation.ftl" />
				</div>
			</#if>



			</div>
		</div>
	</div>

	<section id="content" class="container">
		<div id="contentbody">
		<#if selectable>
			<@liferay_util["include"] page=content_include />
		<#else>
			${portletDisplay.recycle()}

			${portletDisplay.setTitle(the_title)}

			<@liferay_theme["wrap-portlet"] page="portlet.ftl">
				<@liferay_util["include"] page=content_include />
			</@>
		</#if>
		</div>
	</section>
	
	<#assign instanceId = "qqqqqqq" />
	
	<#assign VOID = freeMarkerPortletPreferences.setValue("portletSetupPortletDecoratorId", "barebone") />
	<#assign VOID = freeMarkerPortletPreferences.setValue("articleId", "33623") />
	
	<style>
		#portlet_com_liferay_journal_content_web_portlet_JournalContentPortlet_INSTANCE_${instanceId} h2.portlet-title-text{
			display: none;
		}
	</style>
	
	<footer id="footer" role="contentinfo" class="oecd-footer">
		<@liferay_portlet["runtime"]
			defaultPreferences="${freeMarkerPortletPreferences}"
			portletProviderAction=portletProviderAction.VIEW
			instanceId="${instanceId}"
			portletName="com_liferay_journal_content_web_portlet_JournalContentPortlet"
		/>
	</footer>
	
	${freeMarkerPortletPreferences.reset()}
</div>

<@liferay_util["include"] page=body_bottom_include />

<@liferay_util["include"] page=bottom_include />

<script src="${javascript_folder}/oecd-headers-footers.js" type="text/javascript"></script>



</body>

</html>
