package ru.masterdata.model;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.RoleModel;

public class MdmRoleModel implements RoleModel
{
    private final RoleContainerModel container;
    private final String name;

    public String getId() {
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setName(final String name) {
        throw new ReadOnlyException("Role is read only for this update");
    }

    public String getDescription() {
        return null;
    }

    public void setDescription(final String description) {
        throw new ReadOnlyException("Role is read only for this update");
    }

    public boolean isComposite() {
        return false;
    }

    public void addCompositeRole(final RoleModel role) {
        throw new ReadOnlyException("Role is read only for this update");
    }

    public void removeCompositeRole(final RoleModel role) {
        throw new ReadOnlyException("Role is read only for this update");
    }

    public Stream<RoleModel> getCompositesStream() {
        return Stream.empty();
    }

    public Stream<RoleModel> getCompositesStream(final String s, final Integer integer, final Integer integer1) {
        return null;
    }

    public boolean isClientRole() {
        return false;
    }

    public String getContainerId() {
        return this.container.getId();
    }

    public RoleContainerModel getContainer() {
        return this.container;
    }

    public boolean hasRole(final RoleModel role) {
        return false;
    }

    public Map<String, List<String>> getAttributes() {
        return Collections.emptyMap();
    }

    public void setSingleAttribute(final String name, final String value) {
        throw new ReadOnlyException("Role is read only for this update");
    }

    public void setAttribute(final String name, final List<String> values) {
        throw new ReadOnlyException("Role is read only for this update");
    }

    public void removeAttribute(final String name) {
        throw new ReadOnlyException("Role is read only for this update");
    }

    public Stream<String> getAttributeStream(final String name) {
        return Stream.empty();
    }

    public MdmRoleModel(final RoleContainerModel container, final String name) {
        this.container = container;
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MdmRoleModel that = (MdmRoleModel) o;
        return Objects.equals(container, that.container) && Objects.equals(name, that.name);
    }

    protected boolean canEqual(final Object other) {
        return other instanceof MdmRoleModel;
    }

    @Override
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final Object container = this.getContainer();
        result = result * 59 + ((container == null) ? 43 : container.hashCode());
        final Object name = this.getName();
        result = result * 59 + ((name == null) ? 43 : name.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MdmRoleModel(container=" + this.getContainer() + ", name=" + this.getName() + ")";
    }
}