package ru.masterdata.model;

import java.util.Objects;

public class MdmUserModel
{
    private String login;
    private String email;
    private String passwd;
    private String phone;

    public MdmUserModel(final String login, final String email, final String passwd, final String phone) {
        this.login = login;
        this.email = email;
        this.passwd = passwd;
        this.phone = phone;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        MdmUserModel that = (MdmUserModel) o;
        return login.equals(that.login) && Objects.equals(email, that.email) && Objects.equals(passwd, that.passwd) && Objects.equals(phone, that.phone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(login, email, passwd, phone);
    }

    @Override
    public String toString() {
        return "MdmUserModel(login=" + this.getLogin() + ", email=" + this.getEmail() + ", passwd=" + this.getPasswd() + ", phone=" + this.getPhone() + ")";
    }

    public String getLogin() {
        return this.login;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPasswd() {
        return this.passwd;
    }

    public String getPhone() {
        return this.phone;
    }
}