package ru.masterdata.model;

import org.keycloak.component.ComponentModel;
import org.keycloak.models.*;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.adapter.AbstractUserAdapterFederatedStorage;
import ru.masterdata.utils.DataSourceProvider;

import java.util.List;
import java.util.Set;

public class UserAdapter extends AbstractUserAdapterFederatedStorage
{

    private final MdmUserModel userModel;
    private final String keycloakId;
    private final DataSourceProvider dataSourceProvider;
    private final RealmModel realm;

    public UserAdapter(final KeycloakSession session, final RealmModel realm, final ComponentModel model, final MdmUserModel userModel, final DataSourceProvider dataSourceProvider) {
        super(session, realm, model);
        this.userModel = userModel;
        this.keycloakId = StorageId.keycloakId(model, userModel.getLogin().toLowerCase());
        this.dataSourceProvider = dataSourceProvider;
        this.realm = realm;
    }

    public Set<RoleModel> getClientRoleMappings(final ClientModel app) {
        return this.getRoleMappings();
    }

    public Set<RoleModel> getRoleMappings() {
        return this.dataSourceProvider.getUserRoles(this.userModel.getLogin(), (RoleContainerModel)this.realm);
    }

    public String getPassword() {
        return this.userModel.getPasswd();
    }

    public String getUsername() {
        return this.userModel.getLogin();
    }

    public void setUsername(final String username) {
        throw new ReadOnlyException("Role is read only for this update");
    }

    public void setEmail(final String email) {
        throw new ReadOnlyException("Role is read only for this update");
    }

    public String getEmail() {
        return this.userModel.getEmail();
    }

    public String getId() {
        return this.keycloakId;
    }

    public void setSingleAttribute(final String name, final String value) {
        throw new ReadOnlyException("Role is read only for this update");
    }

    public void removeAttribute(final String name) {
        throw new ReadOnlyException("Role is read only for this update");
    }

    public void setAttribute(final String name, final List<String> values) {
        throw new ReadOnlyException("Role is read only for this update");
    }


}