package ru.masterdata.storage.user;

import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.component.ComponentModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.storage.UserStorageProviderFactory;
import ru.masterdata.utils.DataSourceProvider;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class MdmUserStorageProviderFactory implements UserStorageProviderFactory<MdmUserStorageProvider> {
    private static final Logger logger = Logger.getLogger(MdmUserStorageProviderFactory.class);
    private static final String MODULE_NAME = "masterdata-user-storage-jpa";
    private static final String MODULE_DESC = "JPA Masterdata User Storage Provider";
    private DataSourceProvider dataSourceProv;

    public MdmUserStorageProviderFactory() {

    }

    @Override
    public void init(final Config.Scope config) {
        this.initDataSource("java:/jdbc/smdm");
    }

    private void initDataSource(final String jndiDataSourceName) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            final DataSource dataSource = (DataSource) ctx.lookup(jndiDataSourceName);
            this.dataSourceProv = new DataSourceProvider(dataSource);
        } catch (NamingException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public MdmUserStorageProvider create(final KeycloakSession session, final ComponentModel model) {
        try {
            return new MdmUserStorageProvider(model, session, this.dataSourceProv);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getId() {
        return MODULE_NAME;
    }

    @Override
    public String getHelpText() {
        return MODULE_DESC;
    }

    public void close() {
        MdmUserStorageProviderFactory.logger.info((Object) "<<<<<< Closing factory");
    }


}