package ru.masterdata.utils;

import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.MessageDigest;
import java.nio.charset.Charset;

public class MD5Utils
{
    private static final Charset UTF_8=StandardCharsets.UTF_8;
    private static final String OUTPUT_FORMAT = "%-20s:%s";

    private static byte[] digest(final byte[] input) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e);
        }

        return md.digest(input);
    }

    private static String bytesToHex(final byte[] bytes) {
        final StringBuilder sb = new StringBuilder();
        for (final byte b : bytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    public static String getHexString(final String pText) {
        return bytesToHex(digest(pText.getBytes(MD5Utils.UTF_8)));
    }

    public static void main(final String[] args) {
        final String pText = "GPI_cur";
        System.out.println(String.format(OUTPUT_FORMAT, "Input (string)", "GPI_cur"));
        System.out.println(String.format(OUTPUT_FORMAT, "Input (length)", "GPI_cur".length()));
        final byte[] md5InBytes = digest("GPI_cur".getBytes(MD5Utils.UTF_8));
        System.out.println(String.format(OUTPUT_FORMAT, "MD5 (hex) ", bytesToHex(md5InBytes)));
        System.out.println(String.format(OUTPUT_FORMAT, "MD5 (length)", md5InBytes.length));
    }


}